// Persistence of Vision Ray Tracer Macro File
// tornado macro version 2, by bob hughes, June 2001
// Note: requires MegaPOV v0.4 or greater.  1 POV Unit = 1 Meter
// clockmod.inc is used for animation, not needed for stills. Units in meters.
// The Clock Modifier Include is at  http://www.geocities.com/ccolefax/

#macro Tornado(Type,XYZ,XYZ2,MaxHeight,MinHeight,MaxWidth,MinWidth,Deviation,RND,ColorD,ColorH,ColorF,MediaScatter,Sample,Halo,HH,Animate)

#debug "\n ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ \n"
#debug "\n Tornado macro version 2, by Bob Hughes, June 2001 \n"
#debug "\n ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ \n"

// type chosen
#switch (asc(strlwr(Type)))
 #case (100)
#declare typeD=yes; // dustdevil
#declare typeT=no; // tornado
#declare typeW=yes; // whirlwind
#declare WindyObject="Dustdevil"
 #break
 #case (116)
#declare typeD=yes; // dustdevil
#declare typeT=yes; // tornado
#declare typeW=yes; // whirlwind
#declare WindyObject="Tornado"
 #break
 #case (119)
#declare typeD=no; // dustdevil
#declare typeT=no; // tornado
#declare typeW=yes; // whirlwind
#declare WindyObject="Whirlwind"
 #break
#end

 // motion_blur {

#declare MinH=abs(MinHeight-(MaxHeight/20));

#declare Spin=clock; // rotation

#if (Animate=yes)

#declare AnimateYesNo="Yes"

#declare clock_type="O"
#include "clockmod.inc"
#declare CMoC=mclock*2; // funnel curvature oscillation variable

#declare CMoD=mclock*4; // media dust turbulence oscillation variable

#declare CMoF=mclock*3; // media funnel turbulence oscillation variable

#declare clock_type="S"
#include "clockmod.inc"
#declare CMoT=mclock; // translation s-curve variable

#else

#declare CMoC=0;
#declare CMoD=0;
#declare CMoF=0;
#declare CMoT=0;

#end // if animated

// dust plume densities
#declare Spira=density {spiral1 5 turbulence .5+(CMoF/60) //frequency 9
                        density_map {
                                [0 rgb 0]
                                [.25 rgb .53/2-(MinH/99)]
                                [1 rgb 1.9/2-(MinH/99)]
                                } rotate 0*x}

#declare Spheri=density {spherical turbulence .25+(CMoF/90) //frequency 2
                        density_map {
                                [0 rgb 0]
                                [.167 rgb .62/2-(MinH/99)]
                                [1 rgb 1.94/2-(MinH/99)]
                                }}

#declare None=density {rgb 0}

// funnel densities
#declare FunD0=
                density {spiral1 3 turbulence .25+(CMoF/20) frequency 15
                        density_map {
                                [0 rgb 0]
                                [.1 rgb .1]
                                [1 rgb .2]
                                } rotate 0*x scale <5,.5,5>/10 rotate -360*clock*y}

#declare FunD1=
                density {spiral1 7 turbulence .25+(CMoF/30) frequency 14
                        density_map {
                                [0 rgb .1]
                                [.1 rgb .2]
                                [1 rgb .3]
                                } rotate 0*x scale <5,1,5>/10 rotate -720*clock*y}

#declare FunD2=
                density {spiral1 9 turbulence .25+(CMoF/40) frequency 13
                        density_map {
                                [0 rgb .5]
                                [.1 rgb 1]
                                [1 rgb 1.5]
                                } rotate 0*x scale <5,1.5,5>/10 rotate -1440*clock*y}

// randoms
#declare Rx0=(rand(seed(1+RND))+(CMoC/10))*6;
#declare Rx1=(rand(seed(2+RND))+(CMoC/10))*5;
#declare Rx2=(rand(seed(3+RND))+(CMoC/9))*3;
#declare Rx3=(rand(seed(4+RND))+(CMoC/7))*2;
#declare Rx4=(rand(seed(5+RND))+(CMoC/5))*1.5;
#declare Rx5=(rand(seed(6+RND))+(CMoC/3))*1;
#declare Rx6=(rand(seed(7+RND))+(CMoC/2))*.5;
#declare Rx7=(rand(seed(8+RND))+(CMoC/1))*.1;
#declare Rx8=(rand(seed(9+RND))+(CMoC/1))*0;
#declare Rz0=(rand(seed(10+RND))+(CMoC/10))*6;
#declare Rz1=(rand(seed(11+RND))+(CMoC/10))*5;
#declare Rz2=(rand(seed(12+RND))+(CMoC/9))*3;
#declare Rz3=(rand(seed(13+RND))+(CMoC/7))*2;
#declare Rz4=(rand(seed(14+RND))+(CMoC/5))*1.5;
#declare Rz5=(rand(seed(15+RND))+(CMoC/3))*1;
#declare Rz6=(rand(seed(16+RND))+(CMoC/2))*.5;
#declare Rz7=(rand(seed(17+RND))+(CMoC/1))*.1;
#declare Rz8=(rand(seed(18+RND))+(CMoC/1))*0;

union { // whole union

 union {

#if (typeT=yes)

sphere_sweep { // funnel
  b_spline_sphere_sweep, // b_spline for future compatibility
   9,
  <-Rx0*Deviation, MaxHeight*1.1, Rz0*Deviation>, MaxWidth
  <-Rx1*Deviation, MaxHeight, Rz1*Deviation>, MaxWidth
  <-Rx2*Deviation, MaxHeight*(.9+(CMoC/60)), Rz2*Deviation>, MaxWidth/1.1
  <-Rx3*Deviation, MaxHeight*(.7+(CMoC/50)), Rz3*Deviation>, MaxWidth/1.5
  <Rx4*Deviation, MaxHeight*(.5+(CMoC/45)), -Rz4*Deviation>, MaxWidth/2
  <-Rx5*Deviation, MaxHeight*(.3+(CMoC/40)), -Rz5*Deviation>, MaxWidth/3
  <Rx6*Deviation, MaxHeight*(.2+(CMoC/30)), Rz6*Deviation>, MaxWidth/5
  <Rx7*Deviation, MinH, Rz7*Deviation>, MinWidth
  <-Rx8*Deviation, -1, -Rz8*Deviation>, MinWidth*2
 // sphere_sweep_depth_tolerance 1.0e-3
  texture {
   pigment { rgbf 1 }
    finish { ambient 0 diffuse 0 }
  }
   interior {
        media { // 
                method 2
                intervals 2
                samples 1,2+Sample
                absorption <.26,.25,.24>*.5 emission <.15,.133,.167>*.25
                scattering {3,<.125,.125,.125>*MediaScatter*ColorF extinction .9}
                density {gradient y
                        density_map {
                                [0+(MinH/999) FunD0]
                                [.11+(MinH/333) FunD2]
                                [.33+(MinH/250) FunD1]
                                [.99 FunD0]
                                } ramp_wave frequency 1 scale MaxHeight*1.1 rotate -360*Spin*y}
                }
  } // interior
// no_shadow
 hollow
 } // sweep

#end // tornado type chosen

#declare HaloOnOff="off"

#if (typeD=yes)

#if (Halo=on)

#declare HaloOnOff="on"

difference {
        
sphere_sweep { // the secondary funnel (halo)
  b_spline_sphere_sweep, // b_spline for future compatibility
   5,
  <Rx4*Deviation, MaxHeight*(.5+(CMoC/45)), -Rz4*Deviation>, MaxWidth/1.5
  <-Rx5*Deviation, MaxHeight*(.3+(CMoC/40)), -Rz5*Deviation>, MaxWidth/1.5
  <Rx6*Deviation, MaxHeight*(.2+(CMoC/30)), Rz6*Deviation>, MaxWidth/2
  <Rx7*Deviation, MinH/15, Rz7*Deviation>, MinWidth*3
  <-Rx8*Deviation, -1, -Rz8*Deviation>, MinWidth*3.3
 // sphere_sweep_depth_tolerance 1.0e-3
}
sphere_sweep { // funnel
  b_spline_sphere_sweep, // b_spline for future compatibility
   9,
  <-Rx0*Deviation, MaxHeight*1.1, Rz0*Deviation>, MaxWidth
  <-Rx1*Deviation, MaxHeight, Rz1*Deviation>, MaxWidth
  <-Rx2*Deviation, MaxHeight*(.9+(CMoC/60)), Rz2*Deviation>, MaxWidth/1.1
  <-Rx3*Deviation, MaxHeight*(.7+(CMoC/50)), Rz3*Deviation>, MaxWidth/1.5
  <Rx4*Deviation, MaxHeight*(.5+(CMoC/45)), -Rz4*Deviation>, MaxWidth/2
  <-Rx5*Deviation, MaxHeight*(.3+(CMoC/40)), -Rz5*Deviation>, MaxWidth/3
  <Rx6*Deviation, MaxHeight*(.2+(CMoC/30)), Rz6*Deviation>, MaxWidth/5
  <Rx7*Deviation, MinH, Rz7*Deviation>, MinWidth
  <-Rx8*Deviation, -1, -Rz8*Deviation>, MinWidth*2
 // sphere_sweep_depth_tolerance 1.0e-3
 scale 1.01
}
  texture {
   pigment { rgbf 1 }
    finish { ambient 0 diffuse 0 }
  }
   interior {
        media {
                method 2
                intervals 2
                samples 1,2+Sample
                absorption <.23,.26,.3>*.33 emission <.11,.12,.13>*.133
                scattering {4,<.05,.049,.048>*MediaScatter*ColorH extinction .8}
                density {gradient y turbulence .025+(CMoF/240) frequency -1
                        density_map {
                                [0 rgb 0]
                                [.1+(1-(HH-.15)) rgb 0]
                                [.2+(1-(HH-.25)) rgb .2]
                                [1 rgb .6]
                                }} scale <4,22.5*(MaxHeight/50),4> rotate -720*Spin*y
        }
        } // interior
// no_shadow
 hollow
} // sweep

#else
 sphere {0,0} // prevent single object in union error
#end

#end // dustdevil type chosen

  rotate -360*Spin*y

} // union of funnel + halo

#if (typeW=yes)

// the dust plume

#if (asc(strlwr(Type))!=119)
difference {
sphere {0,1
 scale <9,4.5,9>*1.5
}
#else
sphere {0,1
 scale <9,4.5,9>*1.5
#end        
#if (asc(strlwr(Type))!=119)
sphere_sweep { // funnel
  b_spline_sphere_sweep, // b_spline for future compatibility
   9,
  <-Rx0*Deviation, MaxHeight*1.1, Rz0*Deviation>, MaxWidth
  <-Rx1*Deviation, MaxHeight, Rz1*Deviation>, MaxWidth
  <-Rx2*Deviation, MaxHeight*(.9+(CMoC/60)), Rz2*Deviation>, MaxWidth/1.1
  <-Rx3*Deviation, MaxHeight*(.7+(CMoC/50)), Rz3*Deviation>, MaxWidth/1.5
  <Rx4*Deviation, MaxHeight*(.5+(CMoC/45)), -Rz4*Deviation>, MaxWidth/2
  <-Rx5*Deviation, MaxHeight*(.3+(CMoC/40)), -Rz5*Deviation>, MaxWidth/3
  <Rx6*Deviation, MaxHeight*(.2+(CMoC/30)), Rz6*Deviation>, MaxWidth/5
  <Rx7*Deviation, MinH, Rz7*Deviation>, MinWidth
  <-Rx8*Deviation, -1, -Rz8*Deviation>, MinWidth*2
 // sphere_sweep_depth_tolerance 1.0e-3
 scale 1.01/(2+(MinWidth/5))
}
#if (asc(strlwr(Type))!=116)
sphere_sweep { // the secondary funnel (halo)
  b_spline_sphere_sweep, // b_spline for future compatibility
   5,
  <Rx4*Deviation, MaxHeight*(.5+(CMoC/45)), -Rz4*Deviation>, MaxWidth/1.5
  <-Rx5*Deviation, MaxHeight*(.3+(CMoC/40)), -Rz5*Deviation>, MaxWidth/1.5
  <Rx6*Deviation, MaxHeight*(.2+(CMoC/30)), Rz6*Deviation>, MaxWidth/2
  <Rx7*Deviation, MinH/15, Rz7*Deviation>, MinWidth*3
  <-Rx8*Deviation, -1, -Rz8*Deviation>, MinWidth*3.3
 // sphere_sweep_depth_tolerance 1.0e-3
 scale 1.01/(2+(MinWidth/5))
}
#end #end // 
  texture {
   pigment { rgbf 1 }
    finish { ambient 0 diffuse 0 }
  }
   interior {
        media {
                method 3
                intervals 1
                samples 2,3+Sample
                absorption <.27,.275,.28>*.3 emission <.125,.1125,.133>*.3
                scattering {4,<.25,.23,.2>*(.25-(MinH/333))*MediaScatter*ColorD extinction .67}
                density {spherical turbulence .45+(CMoD/32) //frequency 2
                        density_map {
                                [.05 None]
                                [.1 Spira]
                                [.25 None]
                                [.33 Spheri]
                                [.67 Spira]
                                }} scale <9,4.5,9>*1.33
                }
   } // interior
  scale 2+(MinWidth/5) rotate -360*Spin*y
   translate <.25*(1+(CMoC/.25)), 3.5, .25*(1+(CMoC/.25))>
 hollow
} // sphere

#end // whirlwind type chosen

 // scale 1-(CMoT/25) // shrinking size change
    translate XYZ+(XYZ2*CMoT) // ending position

} // whole union

// } // motion blur

#declare Tposition=XYZ+(XYZ2*CMoT);

#debug concat ("\n ",WindyObject," position is currently <",str(Tposition.x,-1,3),"",",",str(Tposition.y,-1,3),"",",",str(Tposition.z,-1,3),">\n")
#debug concat ("\n Media scattering amount is ",str(MediaScatter,-1,3),"\n")
#debug concat ("\n Halo is ",HaloOnOff,"\n")
#debug concat ("\n Animation? ",AnimateYesNo,"\n")
#debug "\n ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ \n"

#end // macro
